﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ExampleUSBTL50
{
    // This class maps data for advanced settings
    class Tl50
    {
        public AdvancedSegmentAnimationType Animation { get; set; }
        public ColorType Color1 {get; set;}
        public AdvancedSegmentColorIntensityType Color1Intensity { get; set; }
        public ColorType Color2 { get; set; }
        public AdvancedSegmentColorIntensityType Color2Intensity { get; set; }
        public AdvancedSegmentSpeedType Speed { get; set; }
        public AdvancedSegmentPatternType Pattern { get; set; }
        public AdvancedSegmentRotationalDirectionType Direction { get; set; }
        public const int CommArraySize = 3;

        public void GenerateCommArray(ref byte[] Data)
        {
            // Pack data
            Data[0] = (byte)((byte)Color1 | ((byte)Color1Intensity << 4));
            Data[1] = (byte)((byte)Animation | ((byte)Speed << 3) | ((byte)Pattern << 5));
            Data[2] = (byte)((byte)Color2 | ((byte)Color2Intensity << 4) | ((byte)Direction << 7));
        }


        public enum AdvancedSegmentRotationalDirectionType : byte
        {
            DIRECTION_COUNTERCLOCKWISE,
            DIRECTION_CLOCKWISE,
        };
        public enum AdvancedSegmentColorIntensityType : byte
        {
            INTENSITY_HIGH,
            INTENSITY_LOW,
            INTENSITY_MEDIUM,
            INTENSITY_OFF,
            INTENSITY_CUSTOM
        };
        public enum AdvancedSegmentAnimationType : byte
        {
            ANIMATION_OFF,
            ANIMATION_STEADY,
            ANIMATION_FLASH,
            ANIMATION_TWO_COLOR_FLASH,
            ANIMATION_HALF_HALF,
            ANIMATION_HALF_HALF_ROTATE,
            ANIMATION_CASE,
            ANIMATION_INTENSITY_SWEEP,
        };
        public enum AdvancedSegmentSpeedType : byte
        {
            SPEED_STANDARD,
            SPEED_FAST,
            SPEED_SLOW,
            SPEED_CUSTOM,
        };
        public enum AdvancedSegmentPatternType : byte
        {
            PATTERN_NORMAL,
            PATTERN_STROBE,
            PATTERN_THREE_PULSE,
            PATTERN_SOS,
            PATTERN_RANDOM,
        };
        public enum AudibleStateType : byte
        {
            AUDIBLE_STATE_OFF,
            AUDIBLE_STATE_STEADY,
            AUDIBLE_STATE_FLASH,
            AUDIBLE_STATE_SOS
        };
        public enum ColorType : byte
        {
            COLOR_GREEN,
            COLOR_RED,
            COLOR_ORANGE,
            COLOR_AMBER,
            COLOR_YELLOW,
            COLOR_LIME_GREEN,
            COLOR_SPRING_GREEN,
            COLOR_CYAN,
            COLOR_SKY_BLUE,
            COLOR_BLUE,
            COLOR_VIOLET,
            COLOR_MAGENTA,
            COLOR_ROSE,
            COLOR_WHITE,
            COLOR_CUSTOM1,
            COLOR_CUSTOM2,
            COLOR_MAX,
        };

    }
}
