#include "Tl50UsbInterface.h"
#include <stdio.h>

/** A simple C example, linking to the Windows native static library (x64 platform) **/
int main()
{
 	printf("Starting.\n");

	int initRetval = Init();
	if (initRetval <= 0)
	{
		printf("Problem %d while initializing.\n", initRetval);
		return initRetval;
	}
	printf("Connected on port %d.\n", initRetval);

	enum CommReturnValue setRetval = SetSegment(0, SEGMENT_TWO_COLOR_FLASH, GREEN, INTENSITY_HIGH, SPEED_SLOW, FLASH_NORMAL, RED, INTENSITY_LOW, DIRECTION_COUNTERCLOCKWISE);
	if (setRetval != SUCCESS)
	{
		printf("Problem %d while setting segment 0 to color green-red flash.\n", setRetval);
		return setRetval;
	}
	printf("Set the light to green-red flash.\n");

	printf("Exiting.\n");
	return 0;
}
