﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ExampleUSBTL50
{
    public partial class AdvancedOptions : Form
    {
        public AdvancedOptions()
        {
            InitializeComponent();
        }

        private void AdvancedOptions_Load(object sender, EventArgs e)
        {
            foreach (string Color in _COLORS)
            {
                Color1Cb.Items.Add(Color);
                Color2Cb.Items.Add(Color);
            }
            Color1Cb.SelectedIndex = 0;
            Color2Cb.SelectedIndex = 0;
            foreach (string Intensity in _COLOR_INTENSITY)
            {
                Color1IntensityCb.Items.Add(Intensity);
                Color2IntensityCb.Items.Add(Intensity);
            }
            Color1IntensityCb.SelectedIndex = 0;
            Color2IntensityCb.SelectedIndex = 0;
            foreach (string Animation in _ANIMATIONS)
            {
                AnimationCn.Items.Add(Animation);
            }
            AnimationCn.SelectedIndex = 0;
            foreach (string Speed in _SPEEDS)
            {
                SpeedCb.Items.Add(Speed);
            }
            SpeedCb.SelectedIndex = 0;
            foreach (string Pattern in _PATTERNS)
            {
                PatternCb.Items.Add(Pattern);
            }
            PatternCb.SelectedIndex = 0;
            foreach (string Direction in _DIRECTIONS)
            {
                DirectionCb.Items.Add(Direction);
            }
            DirectionCb.SelectedIndex = 0;
            foreach (string Audible in _AUDIBLES)
            {
                AudibleCb.Items.Add(Audible);
            }
            AudibleCb.SelectedIndex = 0;
            SegmentNumberTb.Text = "1";  // control will be 1-based index
        }

        private static readonly string[] _ANIMATIONS = { "Off", "Steady", "Flash", "Two Color Flash", "Half/Half", "Half/Half Rotate", "Chase", "Intensity Sweep" };
        private static readonly string[] _COLORS = { "Green", "Red", "Orange", "Amber", "Yellow", "Lime Green", "Spring Green", "Cyan", "Sky Blue", "Blue", "Violet", "Magenta", "Rose", "White" };
        private static readonly string[] _COLOR_INTENSITY = { "High", "Low", "Medium", "Off"};
        private static readonly string[] _SPEEDS = { "Standard", "Fast", "Slow"};
        private static readonly string[] _PATTERNS = { "Normal", "Strobe", "Three Pulse", "SOS", "Random"};
        private static readonly string[] _DIRECTIONS = { "CCW", "CW"};
        private static readonly string[] _AUDIBLES = { "Off", "Steady", "Pulsed", "SOS" };

        private void WriteBtn_Click(object sender, EventArgs e)
        {
            Tl50 Segment = new Tl50();
            byte[] CommArray = new byte[Tl50.CommArraySize];
            Segment.Color1 = (Tl50.ColorType)Color1Cb.SelectedIndex;
            Segment.Color1Intensity = (Tl50.AdvancedSegmentColorIntensityType)Color1IntensityCb.SelectedIndex;
            Segment.Color2 = (Tl50.ColorType)Color2Cb.SelectedIndex;
            Segment.Color2Intensity = (Tl50.AdvancedSegmentColorIntensityType)Color2IntensityCb.SelectedIndex; ;
            Segment.Animation = (Tl50.AdvancedSegmentAnimationType)AnimationCn.SelectedIndex;
            Segment.Speed = (Tl50.AdvancedSegmentSpeedType)SpeedCb.SelectedIndex;
            Segment.Pattern = (Tl50.AdvancedSegmentPatternType)PatternCb.SelectedIndex;
            Segment.Direction = (Tl50.AdvancedSegmentRotationalDirectionType)DirectionCb.SelectedIndex;
            Segment.GenerateCommArray(ref CommArray);
            // Should check
            int SegmentNumber = int.Parse(SegmentNumberTb.Text) - 1;
            int Response = Form1.SetSegmentAdvanced(SegmentNumber, CommArray);
            if(Response != 0)
            {
                Form1.ShowErrorMessage(Response);
            }
            // Sound (ignored on models without an audible segment)
            Form1.SetAudible(AudibleCb.SelectedIndex);
        }
    }
}
