﻿using Banner.TL50;
 
namespace TL50UsbDotNetCoreExample
{
	/// <summary>
	/// A simple example showing how to use the "TL50 Pro Tower Light with USB"
	/// .NET Standard library in a .NET Core application.
	/// </summary>
	/// <remarks>
	/// Notice that the NuGet.config file in the solution directory is setup to
	/// use this project directory as a source of NuGet packages.
	/// This allows the project to depend on the local copy of the
	/// "BannerTL50.*.nupkg" package.
	/// Similarly, there is a NuGet.config file in the project directory that
	/// does the same thing, for when the project is built directly (not
	/// through the solution).
	/// </remarks>
	class Program
	{
		static void Main()
		{
			using (TL50Usb device = new TL50Usb())
			{
				device.Init("COM6");  // connect to COM6 (replace with the correct port for your system, e.g. /dev/ttyUSB0)
				// Example  that causes a spinning purple and yellow animation:
				device.SetSegment(animation: SegmentAnimation.HalfHalfRotate, color1: Color.Violet, color2: Color.Yellow);
				// Example that turns on the audible (only works on models that include an audible segment)
				var segments = new AllSegmentSettings();
				segments.AudibleSegment = Audible.Pulsed;
				device.SetSegments(segments);
			}
		}
	}
}
